//Best Fit Memory Allocation, the operating system searches the whole memory according to the size of the given process 
//and allocates it to the smallest hole which is big enough to accommodate it.


function [bf_allot]=bestFit(p,b,size_process, size_block)
  

//    declaring best fit flag array(bf_flag) which is used for maintaining the status of each block(free or busy)
  
    bf_allot = zeros(1,size_process);           //    declaring best fit array(bf_allot)
    bf_flag = zeros(1,size_block);
    
    // For loop for allocating blocks according to best fit 
    for i=1:size_process
        k = -1;                          // k - index position of the smallest block which can accommodate a process, initially set to -1
        for j=1:size_block
            if p(i)<=b(j) && bf_flag(j) == 0 then // if process size is less than block size and block is free
                if k==-1 then
                    k = j;              // update k with index position of the block
                elseif(b(j)<b(k))       // if there is a smaller block which can accommodate the process
                    k = j;              // update k with the index position of the smaller block
                end,
            end,         
        end
        if(k==-1)
            bf_allot(i)=0;             // if no block can accomodate the process, set allotted block number as 0
        else
            bf_allot(i) = k;        // store the selected index in the best fit array in the index position i(process number)
            bf_flag(k) = 1;         // set the status of the selected block as busy
        end,
    end
endfunction
